/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import org.sonar.api.internal.apachecommons.lang.StringUtils;

public class RuleTagFormat {
    private static final String VALID_CHARACTERS_REGEX = "^[a-z0-9\\+#\\-\\.]+$";

    private RuleTagFormat() {
    }

    public static boolean isValid(String tag) {
        return StringUtils.isNotBlank(tag) && tag.matches(VALID_CHARACTERS_REGEX);
    }

    public static void validate(String tag) {
        if (!RuleTagFormat.isValid(tag)) {
            throw new IllegalArgumentException(String.format("Tag '%s' is invalid. Rule tags accept only the characters: a-z, 0-9, '+', '-', '#', '.'", tag));
        }
    }
}

